/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.client.screen.widget;

import com.google.common.annotations.Beta;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.framework.api.client.screen.ItemSprites;
import com.mrcrayfish.framework.api.client.screen.widget.layout.Border;
import com.mrcrayfish.framework.api.client.screen.widget.layout.Padding;
import com.mrcrayfish.framework.client.ClientUtils;
import com.mrcrayfish.framework.platform.ClientServices;
import com.mrcrayfish.framework.util.Utils;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_4280;
import net.minecraft.class_5244;
import org.jetbrains.annotations.Nullable;

@Beta
public class FrameworkSelectionList
extends class_4280<Item> {
    public static final class_2960 DEFAULT_BACKGROUND = Utils.rl("widget/selection_list/background");
    public static final ItemSprites DEFAULT_ITEM_SPRITE = ItemSprites.builder().setEnabledSelected(Utils.rl("widget/selection_list/item_enabled_selected")).setEnabledHoveredSelected(Utils.rl("widget/selection_list/item_enabled_selected")).build();
    public static final Padding DEFAULT_LIST_PADDING = Padding.of(4);
    public static final Border DEFAULT_LIST_BORDER = Border.of(0);
    public static final ItemSprites DEFAULT_SCROLLER_SPRITE = ItemSprites.of(class_2960.method_60656((String)"widget/scroller"));
    public static final class_2960 DEFAULT_SCROLL_BAR_BACKGROUND = class_2960.method_60656((String)"widget/scroller_background");
    public static final Padding DEFAULT_SCROLL_BAR_PADDING = Padding.of(0);
    public static final Border DEFAULT_SCROLL_BAR_BORDER = Border.of(0);
    public static final Padding DEFAULT_SCROLL_BAR_CONTAINER_PADDING = Padding.of(0);
    @Nullable
    protected ItemSprites itemSprites = DEFAULT_ITEM_SPRITE;
    protected int itemSpacing = 0;
    @Nullable
    protected class_2960 listBackground = DEFAULT_BACKGROUND;
    protected Border listBorder = DEFAULT_LIST_BORDER;
    protected Padding listPadding = DEFAULT_LIST_PADDING;
    protected boolean scrolling;
    protected boolean scrollBarAlwaysVisible;
    protected int scrollBarSpacing = 4;
    protected ScrollBarStyle scrollBarStyle = ScrollBarStyle.DETACHED;
    @Nullable
    protected ItemSprites scrollerSprites = DEFAULT_SCROLLER_SPRITE;
    protected int scrollerWidth = 6;
    protected int minScrollerHeight = 32;
    @Nullable
    protected class_2960 scrollBarBackground = DEFAULT_SCROLL_BAR_BACKGROUND;
    protected Border scrollBarBorder = DEFAULT_SCROLL_BAR_BORDER;
    protected Padding scrollBarPadding = DEFAULT_SCROLL_BAR_PADDING;
    protected Padding scrollBarContainerPadding = DEFAULT_SCROLL_BAR_CONTAINER_PADDING;
    @Nullable
    protected Supplier<Boolean> activeSupplier;

    public FrameworkSelectionList(int width, int height, int x, int y, int itemHeight) {
        super(class_310.method_1551(), width, height, y, itemHeight);
        this.method_48229(x, y);
    }

    public void method_48229(int x, int y) {
        super.method_48229(x, y);
        this.method_55445(this.field_22758, this.field_22759);
    }

    public void setListBackground(@Nullable class_2960 background) {
        this.listBackground = background;
    }

    public void setListBorder(int size) {
        this.listBorder = Border.of(size);
    }

    public void setListBorder(int left, int top, int right, int bottom) {
        this.listBorder = Border.of(left, top, right, bottom);
    }

    public void setListBorder(Border border) {
        this.listBorder = border;
    }

    public void setListPadding(int padding) {
        this.listPadding = Padding.of(padding);
    }

    public void setListPadding(int left, int top, int right, int bottom) {
        this.listPadding = Padding.of(left, top, right, bottom);
    }

    public void setListPadding(Padding padding) {
        this.listPadding = padding;
    }

    public void setItemSpacing(int itemSpacing) {
        this.itemSpacing = itemSpacing;
    }

    public void setItemSprites(@Nullable ItemSprites sprites) {
        this.itemSprites = sprites;
    }

    public void setScrollerWidth(int width) {
        this.scrollerWidth = width;
    }

    public void setScrollerMinHeight(int minHeight) {
        this.minScrollerHeight = minHeight;
    }

    public void setScrollerSprites(@Nullable ItemSprites sprites) {
        this.scrollerSprites = sprites;
    }

    public void setScrollBarBackground(@Nullable class_2960 background) {
        this.scrollBarBackground = background;
    }

    public void setScrollBarBorder(int size) {
        this.scrollBarBorder = Border.of(size);
    }

    public void setScrollBarBorder(int left, int top, int right, int bottom) {
        this.scrollBarBorder = Border.of(left, top, right, bottom);
    }

    public void setScrollBarBorder(Border border) {
        this.scrollBarBorder = border;
    }

    public void setScrollBarStyle(ScrollBarStyle scrollBarStyle) {
        this.scrollBarStyle = scrollBarStyle;
    }

    public void setScrollBarAlwaysVisible(boolean scrollBarAlwaysVisible) {
        this.scrollBarAlwaysVisible = scrollBarAlwaysVisible;
    }

    public void setScrollBarSpacing(int scrollBarSpacing) {
        this.scrollBarSpacing = scrollBarSpacing;
    }

    public void setScrollBarPadding(int padding) {
        this.scrollBarPadding = Padding.of(padding);
    }

    public void setScrollBarPadding(int left, int top, int right, int bottom) {
        this.scrollBarPadding = Padding.of(left, top, right, bottom);
    }

    public void setScrollBarContainerPadding(int size) {
        this.scrollBarContainerPadding = Padding.of(size);
    }

    public void setScrollBarContainerPadding(int left, int top, int right, int bottom) {
        this.scrollBarContainerPadding = Padding.of(left, top, right, bottom);
    }

    public void setScrollBarContainerPadding(Padding padding) {
        this.scrollBarContainerPadding = padding;
    }

    public void setActive(@Nullable Supplier<Boolean> activeSupplier) {
        this.activeSupplier = activeSupplier;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseY >= (double)this.method_46427() && mouseY <= (double)(this.method_46427() + this.method_25364()) && mouseX >= (double)this.method_46426() && mouseX <= (double)(this.method_46426() + this.method_25368());
    }

    public int method_25322() {
        return this.method_31383() - this.method_25342();
    }

    public int method_25342() {
        return this.method_46426() + this.listBorder.left() + this.listPadding.left();
    }

    public int method_31383() {
        if (this.method_25331() > 0 || this.scrollBarAlwaysVisible) {
            int scrollBarArea = switch (this.scrollBarStyle.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.listPadding.right() + this.listBorder.right() + this.scrollBarSpacing + this.scrollBarContainerPadding.left() + this.scrollBarBorder.left() + this.scrollBarPadding.left() + this.scrollerWidth + this.scrollBarPadding.right() + this.scrollBarBorder.right() + this.scrollBarContainerPadding.right();
                case 1 -> this.scrollBarSpacing + this.scrollBarContainerPadding.left() + this.scrollBarBorder.left() + this.scrollBarPadding.left() + this.scrollerWidth + this.scrollBarPadding.right() + this.scrollBarBorder.right() + this.scrollBarContainerPadding.right() + this.listPadding.right() + this.listBorder.right();
            };
            return this.method_46426() + this.method_25368() - scrollBarArea;
        }
        return this.method_46426() + this.method_25368() - this.listPadding.right() - this.listBorder.right();
    }

    protected int method_25337(int index) {
        return this.method_46427() + this.listBorder.top() + this.listPadding.top() - (int)this.method_25341() + index * this.field_22741 + index * this.itemSpacing;
    }

    protected int method_25329() {
        int offset = switch (this.scrollBarStyle.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.scrollerWidth + this.scrollBarPadding.right() + this.scrollBarBorder.right() + this.scrollBarContainerPadding.right();
            case 1 -> this.scrollerWidth + this.scrollBarPadding.right() + this.scrollBarBorder.right() + this.scrollBarContainerPadding.right() + this.listPadding.right() + this.listBorder.right();
        };
        return this.method_46426() + this.method_25368() - offset;
    }

    protected int getScrollbarHeight() {
        int scrollAreaHeight = this.getScrollAreaHeight();
        int scrollBarHeight = (int)((float)class_3532.method_34954((int)scrollAreaHeight) / (float)this.method_25317());
        return class_3532.method_15340((int)scrollBarHeight, (int)this.minScrollerHeight, (int)scrollAreaHeight);
    }

    protected int getScrollAreaHeight() {
        int offset = switch (this.scrollBarStyle.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.scrollBarContainerPadding.top() + this.scrollBarBorder.top() + this.scrollBarPadding.top() + this.scrollBarPadding.bottom() + this.scrollBarBorder.bottom() + this.scrollBarContainerPadding.bottom();
            case 1 -> this.listBorder.top() + this.listPadding.top() + this.scrollBarContainerPadding.top() + this.scrollBarBorder.top() + this.scrollBarPadding.top() + this.scrollBarPadding.bottom() + this.scrollBarBorder.bottom() + this.scrollBarContainerPadding.bottom() + this.listPadding.bottom() + this.listBorder.bottom();
        };
        return this.method_25364() - offset;
    }

    protected int getScrollAreaTop() {
        int offset = switch (this.scrollBarStyle.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.scrollBarContainerPadding.top() + this.scrollBarBorder.top() + this.scrollBarPadding.top();
            case 1 -> this.listBorder.top() + this.listPadding.top() + this.scrollBarContainerPadding.top() + this.scrollBarBorder.top() + this.scrollBarPadding.top();
        };
        return this.method_46427() + offset;
    }

    public int method_25331() {
        return Math.max(0, this.method_25317() - this.field_22759 + this.listBorder.top() + this.listPadding.top() + this.listPadding.bottom() + this.listBorder.bottom());
    }

    protected int method_25317() {
        return this.method_25340() * (this.field_22741 + this.itemSpacing) - this.itemSpacing;
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (this.activeSupplier != null) {
            this.field_22763 = this.activeSupplier.get();
        }
        this.renderListBackground(graphics, mouseX, mouseY, partialTick);
        this.method_25311(graphics, mouseX, mouseY, partialTick);
        this.renderScrollBar(graphics, mouseX, mouseY, partialTick);
    }

    protected int getListBackgroundWidth() {
        return switch (this.scrollBarStyle.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.listBorder.left() + this.listPadding.left() + this.method_25322() + this.listPadding.right() + this.listBorder.right();
            case 1 -> this.method_25368();
        };
    }

    protected int getListBackgroundHeight() {
        return this.method_25364();
    }

    protected void renderListBackground(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (this.listBackground != null) {
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            graphics.method_52706(this.listBackground, this.method_46426(), this.method_46427(), this.getListBackgroundWidth(), this.getListBackgroundHeight());
            RenderSystem.disableBlend();
        }
    }

    protected void renderScrollBar(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        int maxScroll = this.method_25331();
        if (maxScroll > 0 || this.scrollBarAlwaysVisible) {
            if (this.scrollBarBackground != null) {
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
                int scrollBarTop = this.method_46427();
                if (this.scrollBarStyle == ScrollBarStyle.MERGED) {
                    scrollBarTop += this.listBorder.top() + this.listPadding.top() + this.scrollBarContainerPadding.top();
                }
                int scrollBarLeft = this.method_25329() - this.scrollBarPadding.left() - this.scrollBarBorder.left();
                int scrollBarAreaWidth = this.scrollBarBorder.left() + this.scrollBarPadding.left() + this.scrollerWidth + this.scrollBarPadding.right() + this.scrollBarBorder.right();
                int scrollBarAreaHeight = this.method_25364() - this.scrollBarContainerPadding.top() - this.scrollBarContainerPadding.bottom();
                if (this.scrollBarStyle == ScrollBarStyle.MERGED) {
                    scrollBarAreaHeight -= this.listBorder.top() + this.listPadding.top() + this.listPadding.bottom() + this.listBorder.bottom();
                }
                graphics.method_52706(this.scrollBarBackground, scrollBarLeft, scrollBarTop, scrollBarAreaWidth, scrollBarAreaHeight);
                RenderSystem.disableBlend();
            }
            boolean scrollBarEnabled = maxScroll > 0;
            int scrollBarStart = this.method_25329();
            int scrollBarEnd = scrollBarStart + this.scrollerWidth;
            int scrollBarHeight = this.getScrollbarHeight();
            int scrollBarTop = (int)((double)this.getScrollAreaTop() + (double)(this.getScrollAreaHeight() - this.getScrollbarHeight()) * (this.method_25341() / (double)Math.max(maxScroll, 1)));
            boolean scrollBarHovered = ClientUtils.isPointInArea(mouseX, mouseY, scrollBarStart, scrollBarTop, this.scrollerWidth, scrollBarHeight);
            if (this.scrollerSprites != null) {
                class_2960 sprite = this.scrollerSprites.getSprite(scrollBarEnabled, scrollBarHovered, this.scrolling);
                if (sprite != null) {
                    RenderSystem.enableBlend();
                    RenderSystem.enableDepthTest();
                    graphics.method_51422(1.0f, 1.0f, 1.0f, this.field_22763 ? 1.0f : 0.5f);
                    graphics.method_52706(sprite, scrollBarStart, scrollBarTop, scrollBarEnd - scrollBarStart, scrollBarHeight);
                    graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
                    RenderSystem.disableBlend();
                }
            } else {
                int scrollBarColour = scrollBarHovered ? -13423059 : -12107714;
                graphics.method_25294(scrollBarStart, scrollBarTop, scrollBarEnd, scrollBarTop + scrollBarHeight, scrollBarColour);
            }
        }
    }

    protected void method_25311(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        int startIndex;
        int rowTop;
        graphics.method_44379(this.method_25342(), this.method_46427() + this.listBorder.top(), this.method_31383(), this.method_46427() + this.method_25364() - this.listBorder.bottom());
        int rowLeft = this.method_25342();
        int rowWidth = this.method_25322();
        int rowHeight = this.field_22741;
        int rowCount = this.method_25340();
        for (int i = startIndex = Math.max(0, (int)((this.method_25341() - (double)this.listPadding.top()) / (double)(rowHeight + this.itemSpacing))); i < rowCount && (rowTop = this.method_25337(i)) <= this.method_46427() + this.method_25364(); ++i) {
            boolean hovered = !this.scrolling && ClientUtils.isPointInArea(mouseX, mouseY, rowLeft, rowTop, rowWidth, rowHeight);
            boolean selected = this.method_25332(i);
            Item item = (Item)this.method_25326(i);
            item.setHovered(hovered);
            item.renderBackground(this.itemSprites, graphics, i, rowLeft, rowTop, rowWidth, rowHeight, mouseX, mouseY, hovered, selected);
            item.method_25343(graphics, i, rowTop, rowLeft, rowWidth, rowHeight, mouseX, mouseY, selected, partialTick);
        }
        graphics.method_44380();
    }

    protected void method_44398(class_332 graphics, int top, int rowWidth, int rowHeight, int outlineColour, int innerColour) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.field_22763 || !this.method_53812(button)) {
            return false;
        }
        this.method_25318(mouseX, mouseY, button);
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        Item item = this.getEntry(mouseX, mouseY);
        if (item != null && item.method_25402(mouseX, mouseY, button)) {
            Item focused = (Item)this.method_25336();
            if (focused != item && focused instanceof class_4069) {
                class_4069 handler = (class_4069)focused;
                handler.method_25395(null);
            }
            this.method_25395((class_364)item);
            this.method_25398(true);
            return true;
        }
        return this.scrolling;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0) {
            if (this.method_25336() != null && this.method_25397() && ((Item)this.method_25336()).method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
                return true;
            }
            if (this.scrolling) {
                double unitsPerScroll = (double)this.method_25331() / (double)Math.max(1, this.getScrollAreaHeight() - this.getScrollbarHeight());
                this.method_25307(this.method_25341() + deltaY * unitsPerScroll);
                return true;
            }
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        return this.field_22763 && super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    public void addItem(Item item) {
        super.method_25321((class_350.class_351)item);
    }

    @Nullable
    public Item removeItem(int index) {
        if (index >= 0 && index < this.method_25396().size()) {
            Item removed = (Item)super.method_25338(index);
            if (removed != null) {
                this.method_60322();
            }
            return removed;
        }
        return null;
    }

    public boolean removeItem(Item item) {
        boolean result = super.method_25330((class_350.class_351)item);
        if (result) {
            this.method_60322();
        }
        return result;
    }

    public void removeIf(Predicate<? super Item> predicate) {
        if (this.method_25396().removeIf(predicate)) {
            this.method_60322();
        }
    }

    public Item getEntry(double mouseX, double mouseY) {
        int contentHeight;
        int contentWidth;
        int contentTop;
        int contentLeft = this.method_46426() + this.listBorder.left() + this.listPadding.left();
        if (ClientUtils.isPointInArea((int)mouseX, (int)mouseY, contentLeft, contentTop = this.method_46427() + this.listBorder.top(), contentWidth = this.method_25322(), contentHeight = this.method_25364() - this.listBorder.top() - this.listBorder.bottom())) {
            int startIndex;
            int rowTop;
            int rowLeft = this.method_25342();
            int rowWidth = this.method_25322();
            int rowHeight = this.field_22741;
            int rowCount = this.method_25340();
            for (int i = startIndex = Math.max(0, (int)((this.method_25341() - (double)this.listPadding.top()) / (double)(rowHeight + this.itemSpacing))); i < rowCount && (rowTop = this.method_25337(i)) <= this.method_46427() + this.method_25364(); ++i) {
                if (!ClientUtils.isPointInArea((int)mouseX, (int)mouseY, rowLeft, rowTop, rowWidth, rowHeight)) continue;
                return (Item)this.method_25326(i);
            }
        }
        return null;
    }

    protected void method_25318(double mouseX, double mouseY, int button) {
        this.scrolling = this.method_25331() > 0 && button == 0 && ClientUtils.isPointInArea((int)mouseX, (int)mouseY, this.method_25329(), this.getScrollAreaTop(), this.scrollerWidth, this.getScrollAreaHeight());
        ClientServices.CLIENT.setScrollingState((class_350<?>)this, this.scrolling);
    }

    @Nullable
    public Item getSelected() {
        Item selected = (Item)super.method_25334();
        if (selected != null && selected.isSelectable()) {
            return selected;
        }
        return null;
    }

    public void setSelected(@Nullable Item item) {
        if (item == null || item.isSelectable()) {
            super.method_25313((class_350.class_351)item);
        }
    }

    public static enum ScrollBarStyle {
        DETACHED,
        MERGED;

    }

    public static abstract class Item
    extends class_4280.class_4281<Item> {
        private boolean hovered;

        protected abstract void renderContent(class_332 var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, boolean var10, float var11);

        private void setHovered(boolean hovered) {
            this.hovered = hovered;
        }

        public boolean isSelectable() {
            return true;
        }

        public class_2561 method_37006() {
            return class_5244.field_39003;
        }

        public final void method_25343(class_332 graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean selected, float partialTick) {
            this.renderContent(graphics, index, x, y, width, height, mouseX, mouseY, this.hovered, selected, partialTick);
        }

        protected void renderBackground(@Nullable ItemSprites sprites, class_332 graphics, int index, int x, int y, int width, int height, int mouseX, int mouseY, boolean hovered, boolean selected) {
            class_2960 sprite;
            if (sprites != null && (sprite = sprites.getSprite(true, hovered, selected)) != null) {
                graphics.method_52706(sprite, x, y, width, height);
            }
        }
    }
}

